/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.cidslayer;

import Sirius.server.localserver.attribute.MemberAttributeInfo;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.server.cidslayer.StationInfo;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WatergisDefaultCidsLayer
implements CidsLayerInfo,
Serializable {
    private static final String DOMAIN = "DLM25W";
    protected Map<String, String> catalogueNameMap = null;
    protected final MetaClass mc;
    protected final Map<String, Boolean> primitiveTypes = new HashMap<String, Boolean>();
    protected final Map<String, Integer> catalogueTypes = new HashMap<String, Integer>();
    protected final Map<String, StationInfo> stationTypes = new HashMap<String, StationInfo>();
    protected final Map<String, Integer> referencedClass = new HashMap<String, Integer>();
    protected boolean useDistinct = false;
    protected User user = null;
    protected String sqlGeoField;
    protected String geoField;
    private String selectionString;
    private String[] columnNames;
    private String[] sqlColumnNames;
    private String[] columnPropertyNames;
    private String[] primitiveColumnTypes;
    private boolean showFgLa = false;
    private boolean firstFgLa = true;
    private boolean additionalGeom = false;
    private boolean inheritedWwGr = false;
    private String additionalJoins = null;
    private boolean showSgSuAttributes = false;

    public WatergisDefaultCidsLayer(MetaClass mc, User user) {
        this(mc, false, false, null, user);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, boolean showSgSuAttributes, User user) {
        this.mc = mc;
        this.showFgLa = false;
        this.additionalGeom = false;
        this.catalogueNameMap = null;
        this.inheritedWwGr = false;
        this.additionalJoins = null;
        this.showSgSuAttributes = showSgSuAttributes;
        this.user = user;
        if (this.showFgLa) {
            this.useDistinct = true;
        }
        this.init(mc);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, Map<String, String> catalogueNameMap, User user) {
        this(mc, false, false, catalogueNameMap, user);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, boolean inheritedWwGr, String additionalJoins, User user) {
        this(mc, false, false, null, inheritedWwGr, additionalJoins, user);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, boolean showFgLa, boolean additionalGeom, User user) {
        this(mc, showFgLa, additionalGeom, null, user);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, boolean showFgLa, boolean additionalGeom, Map<String, String> catalogueNameMap, User user) {
        this(mc, showFgLa, additionalGeom, catalogueNameMap, false, null, user);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, boolean showFgLa, boolean additionalGeom, Map<String, String> catalogueNameMap, boolean inheritedWwGr, User user) {
        this(mc, showFgLa, additionalGeom, catalogueNameMap, inheritedWwGr, null, user);
    }

    public WatergisDefaultCidsLayer(MetaClass mc, boolean showFgLa, boolean additionalGeom, Map<String, String> catalogueNameMap, boolean inheritedWwGr, String additionalJoins, User user) {
        this.mc = mc;
        this.showFgLa = showFgLa;
        this.additionalGeom = additionalGeom;
        this.catalogueNameMap = catalogueNameMap;
        this.inheritedWwGr = inheritedWwGr;
        this.additionalJoins = additionalJoins;
        this.user = user;
        if (showFgLa) {
            this.useDistinct = true;
        }
        this.init(mc);
    }

    protected void init(MetaClass mc) {
        HashMap attrMap = mc.getMemberAttributeInfos();
        ArrayList<String> sb = new ArrayList<String>();
        StringBuilder joins = new StringBuilder();
        HashMap allClasses = mc.getEmptyInstance().getAllClasses();
        MetaClass geomMc = this.getGeomClass(allClasses);
        ArrayList<String> columnNamesList = new ArrayList<String>();
        ArrayList<String> sqlColumnNamesList = new ArrayList<String>();
        ArrayList<String> columnPropertyNamesList = new ArrayList<String>();
        ArrayList<String> primitiveColumnTypesList = new ArrayList<String>();
        int i = 0;
        int lineId = 0;
        int fgLaPosition = -1;
        String joinExtension = this.additionalGeom ? " left" : "";
        for (Object key : attrMap.keySet()) {
            StationInfo s;
            StationInfo s2;
            String columnName;
            MemberAttributeInfo attr = (MemberAttributeInfo)attrMap.get(key);
            if (this.user != null && !this.hasAttributeReadPermission(mc.getTableName() + "." + attr.getFieldName(), this.user) || !attr.getName().equalsIgnoreCase("id") && !attr.isVisible()) continue;
            if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().endsWith("geom")) {
                this.sqlGeoField = "geo_field";
                this.geoField = attr.getName();
                sb.add("ST_AsEWKb(geom.geo_field) as " + this.geoField);
                columnNamesList.add(attr.getName());
                sqlColumnNamesList.add("geom.geo_field");
                columnPropertyNamesList.add(attr.getName() + ".geo_field");
                joins.append(" join geom on (").append(attr.getFieldName()).append(" = geom.id)");
                primitiveColumnTypesList.add("Geometry");
                this.referencedClass.put(attr.getName(), attr.getForeignKeyClassId());
            } else if (attr.getJavaclassname() != null && attr.getJavaclassname().equalsIgnoreCase("com.vividsolutions.jts.geom.Geometry")) {
                this.sqlGeoField = mc.getTableName() + "." + attr.getName();
                this.geoField = attr.getName();
                sb.add("ST_AsEWKb(" + mc.getTableName() + "." + attr.getName() + ") as " + this.geoField);
                columnNamesList.add(attr.getName());
                sqlColumnNamesList.add(attr.getName());
                columnPropertyNamesList.add(attr.getName());
                primitiveColumnTypesList.add("Geometry");
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_bak_punkt")) {
                this.sqlGeoField = "geo_field";
                columnName = "bak_st";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".real_point.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.fg_bak.ba_cd");
                columnNamesList.add("fg_bak.ba_cd");
                sqlColumnNamesList.add("fg_bak.ba_cd");
                columnPropertyNamesList.add(attr.getName() + ".route.ba_cd");
                sb.add(" stat.wert");
                columnNamesList.add("bak_st");
                sqlColumnNamesList.add("stat.wert");
                columnPropertyNamesList.add(attr.getName() + ".wert");
                joins.append(joinExtension).append(" join dlm25w.fg_bak_punkt stat on (stat.id = ").append(attr.getFieldName()).append(")");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (real_point = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.fg_bak on (stat.route = dlm25w.fg_bak.id)");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                s2 = new StationInfo(false, true, "dlm25w.fg_bak", ++lineId, "fg_bak.ba_cd");
                this.stationTypes.put("bak_st", s2);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_ba_punkt")) {
                this.sqlGeoField = "geo_field";
                columnName = "ba_st";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".real_point.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.fg_ba.ba_cd");
                columnNamesList.add("ba_cd");
                sqlColumnNamesList.add("dlm25w.fg_ba.ba_cd");
                columnPropertyNamesList.add(attr.getName() + ".route.ba_cd");
                sb.add(" stat.wert");
                columnNamesList.add("ba_st");
                sqlColumnNamesList.add("stat.wert");
                columnPropertyNamesList.add(attr.getName() + ".wert");
                joins.append(joinExtension).append(" join dlm25w.fg_ba_punkt stat on (stat.id = ").append(attr.getFieldName()).append(")");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (real_point = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.fg_ba on (stat.route = dlm25w.fg_ba.id)");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                s2 = new StationInfo(false, true, "dlm25w.fg_ba", ++lineId, "ba_cd");
                this.stationTypes.put("ba_st", s2);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_la_punkt")) {
                if (this.showFgLa && this.firstFgLa) {
                    this.firstFgLa = false;
                    fgLaPosition = sb.size();
                    continue;
                }
                if (this.firstFgLa) {
                    this.sqlGeoField = "geo_field";
                    columnName = "la_st";
                    if (!this.additionalGeom) {
                        this.geoField = "geom";
                        sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                        columnNamesList.add(1, "geom");
                        sqlColumnNamesList.add(1, "geom.geo_field");
                        columnPropertyNamesList.add(1, attr.getName() + ".real_point.geo_field");
                        primitiveColumnTypesList.add(1, "Geometry");
                    }
                    sb.add("dlm25w.fg_la.la_cd");
                    columnNamesList.add("la_cd");
                    sqlColumnNamesList.add("dlm25w.fg_la.la_cd");
                    columnPropertyNamesList.add(attr.getName() + ".route.la_cd");
                    sb.add(" statl.wert");
                    columnNamesList.add("la_st");
                    sqlColumnNamesList.add("statl.wert");
                    columnPropertyNamesList.add(attr.getName() + ".wert");
                    joins.append(joinExtension).append(" join dlm25w.fg_la_punkt statl on (statl.id = ").append(attr.getFieldName()).append(")");
                    if (!this.additionalGeom) {
                        joins.append(" join geom on (real_point = geom.id)");
                        this.referencedClass.put(this.geoField, geomMc.getID());
                    }
                    joins.append(joinExtension).append(" join dlm25w.fg_la on (statl.route = dlm25w.fg_la.id)");
                    primitiveColumnTypesList.add("BigDecimal");
                    primitiveColumnTypesList.add("java.lang.Double");
                    s2 = new StationInfo(false, true, "dlm25w.fg_la", ++lineId, "la_cd");
                    this.stationTypes.put("la_st", s2);
                } else {
                    this.sqlGeoField = "geo_field";
                    columnName = "station";
                    if (!this.additionalGeom) {
                        this.geoField = "geom";
                        sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                        columnNamesList.add(1, "geom");
                        sqlColumnNamesList.add(1, "geom.geo_field");
                        columnPropertyNamesList.add(1, attr.getName() + ".real_point.geo_field");
                        primitiveColumnTypesList.add(1, "Geometry");
                    }
                    sb.add("dlm25w.fg_la.la_cd as gwk_lawa");
                    columnNamesList.add("gwk_lawa");
                    sqlColumnNamesList.add("dlm25w.fg_la.la_cd");
                    columnPropertyNamesList.add(attr.getName() + ".route.la_cd");
                    sb.add(" statl.wert as station");
                    columnNamesList.add("station");
                    sqlColumnNamesList.add("statl.wert");
                    columnPropertyNamesList.add(attr.getName() + ".wert");
                    joins.append(joinExtension).append(" join dlm25w.fg_la_punkt statl on (statl.id = ").append(attr.getFieldName()).append(")");
                    if (!this.additionalGeom) {
                        joins.append(" join geom on (real_point = geom.id)");
                        this.referencedClass.put(this.geoField, geomMc.getID());
                    }
                    joins.append(joinExtension).append(" join dlm25w.fg_la on (statl.route = dlm25w.fg_la.id)");
                    primitiveColumnTypesList.add("BigDecimal");
                    primitiveColumnTypesList.add("java.lang.Double");
                    s2 = new StationInfo(false, true, "dlm25w.fg_la", ++lineId, "la_cd");
                    this.stationTypes.put("station", s2);
                }
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_bak_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.fg_bak.ba_cd");
                columnNamesList.add("ba_cd");
                sqlColumnNamesList.add("dlm25w.fg_bak.ba_cd");
                columnPropertyNamesList.add(attr.getName() + ".von.route.ba_cd");
                sb.add(" von.wert as bak_st_von");
                columnNamesList.add("bak_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as bak_st_bis");
                columnNamesList.add("bak_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join dlm25w.fg_bak_linie on (").append(attr.getFieldName()).append(" = dlm25w.fg_bak_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.fg_bak_punkt von on (von.id = dlm25w.fg_bak_linie.von)");
                joins.append(joinExtension).append(" join dlm25w.fg_bak_punkt bis on (bis.id = dlm25w.fg_bak_linie.bis)");
                joins.append(joinExtension).append(" join dlm25w.fg_bak on (bis.route = dlm25w.fg_bak.id)");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "dlm25w.fg_bak", ++lineId, "ba_cd");
                this.stationTypes.put("bak_st_von", s);
                s = new StationInfo(true, false, "dlm25w.fg_bak", lineId, "ba_cd");
                this.stationTypes.put("bak_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_ba_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.fg_ba.ba_cd");
                columnNamesList.add("ba_cd");
                sqlColumnNamesList.add("dlm25w.fg_ba.ba_cd");
                columnPropertyNamesList.add(attr.getName() + ".von.route.ba_cd");
                sb.add(" von.wert as ba_st_von");
                columnNamesList.add("ba_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as ba_st_bis");
                columnNamesList.add("ba_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join dlm25w.fg_ba_linie on (").append(attr.getFieldName()).append(" = dlm25w.fg_ba_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.fg_ba_punkt von on (von.id = dlm25w.fg_ba_linie.von)");
                joins.append(joinExtension).append(" join dlm25w.fg_ba_punkt bis on (bis.id = dlm25w.fg_ba_linie.bis)");
                joins.append(joinExtension).append(" join dlm25w.fg_ba on (von.route = dlm25w.fg_ba.id)");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "dlm25w.fg_ba", ++lineId, "ba_cd");
                this.stationTypes.put("ba_st_von", s);
                s = new StationInfo(true, false, "dlm25w.fg_ba", lineId, "ba_cd");
                this.stationTypes.put("ba_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("sg_su_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.sg_su.su_cd");
                columnNamesList.add("su_cd");
                sqlColumnNamesList.add("dlm25w.sg_su.su_cd");
                columnPropertyNamesList.add(attr.getName() + "route.su_cd");
                sb.add(" von.wert as su_st_von");
                columnNamesList.add("su_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as su_st_bis");
                columnNamesList.add("su_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                if (this.showSgSuAttributes) {
                    sb.add("dlm25w.sg_su.see_gn");
                    columnNamesList.add("see_gn");
                    sqlColumnNamesList.add("dlm25w.sg_su.see_gn");
                    columnPropertyNamesList.add(attr.getName() + ".see_gn");
                    primitiveColumnTypesList.add("String");
                    sb.add("dlm25w.sg_su.see_lawa");
                    columnNamesList.add("see_lawa");
                    sqlColumnNamesList.add("dlm25w.sg_su.see_lawa");
                    columnPropertyNamesList.add(attr.getName() + ".see_lawa");
                    primitiveColumnTypesList.add("String");
                    sb.add("dlm25w.sg_su.see_sp");
                    columnNamesList.add("see_sp");
                    sqlColumnNamesList.add("dlm25w.sg_su.see_sp");
                    columnPropertyNamesList.add(attr.getName() + ".see_sp");
                    primitiveColumnTypesList.add("String");
                }
                joins.append(joinExtension).append(" join dlm25w.sg_su_linie on (").append(attr.getFieldName()).append(" = dlm25w.sg_su_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.sg_su_punkt von on (von.id = dlm25w.sg_su_linie.von)");
                joins.append(joinExtension).append(" join dlm25w.sg_su_punkt bis on (bis.id = dlm25w.sg_su_linie.bis)");
                joins.append(joinExtension).append(" join dlm25w.sg_su on (bis.route = dlm25w.sg_su.id)");
                s = new StationInfo(true, true, "dlm25w.sg_su", ++lineId, "su_cd");
                this.stationTypes.put("su_st_von", s);
                s = new StationInfo(true, false, "dlm25w.sg_su", lineId, "su_cd");
                this.stationTypes.put("su_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_la_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.k_gwk_lawa.la_cd");
                columnNamesList.add("la_cd");
                sqlColumnNamesList.add("dlm25w.k_gwk_lawa.la_cd");
                columnPropertyNamesList.add(attr.getName() + ".von.route.la_cd.la_cd");
                sb.add(" von.wert as la_st_von");
                columnNamesList.add("la_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as la_st_bis");
                columnNamesList.add("la_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join dlm25w.fg_la_linie on (").append(attr.getFieldName()).append(" = dlm25w.fg_la_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.fg_la_punkt von on (von.id = dlm25w.fg_la_linie.von)");
                joins.append(joinExtension).append(" join dlm25w.fg_la_punkt bis on (bis.id = dlm25w.fg_la_linie.bis)");
                joins.append(joinExtension).append(" join dlm25w.fg_la on (bis.route = dlm25w.fg_la.id)");
                joins.append(joinExtension).append(" join dlm25w.k_gwk_lawa on (dlm25w.k_gwk_lawa.id").append(" = dlm25w.fg_la.la_cd)");
                primitiveColumnTypesList.add("BigDecimal");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "dlm25w.fg_la", ++lineId, "la_cd");
                this.stationTypes.put("la_st_von", s);
                s = new StationInfo(true, false, "dlm25w.fg_la", lineId, "la_cd");
                this.stationTypes.put("la_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_lak_linie") && !this.showFgLa) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("dlm25w.k_gwk_lawa.la_cd");
                columnNamesList.add("la_cd");
                sqlColumnNamesList.add("dlm25w.k_gwk_lawa.la_cd");
                columnPropertyNamesList.add(attr.getName() + ".von.route.la_cd.la_cd");
                sb.add(" von.wert as lak_st_von");
                columnNamesList.add("lak_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as lak_st_bis");
                columnNamesList.add("lak_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join dlm25w.fg_lak_linie on (").append(attr.getFieldName()).append(" = dlm25w.fg_lak_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join dlm25w.fg_lak_punkt von on (von.id = dlm25w.fg_lak_linie.von)");
                joins.append(joinExtension).append(" join dlm25w.fg_lak_punkt bis on (bis.id = dlm25w.fg_lak_linie.bis)");
                joins.append(joinExtension).append(" join dlm25w.fg_lak on (bis.route = dlm25w.fg_lak.id)");
                joins.append(joinExtension).append(" join dlm25w.k_gwk_lawa on (dlm25w.k_gwk_lawa.id").append(" = dlm25w.fg_lak.la_cd)");
                primitiveColumnTypesList.add("BigDecimal");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "dlm25w.fg_lak", ++lineId, "la_cd");
                this.stationTypes.put("lak_st_von", s);
                s = new StationInfo(true, false, "dlm25w.fg_lak", lineId, "la_cd");
                this.stationTypes.put("lak_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_ba_duv_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("duv.fg_ba_duv.ba_cd");
                columnNamesList.add("ba_cd");
                sqlColumnNamesList.add("duv.fg_ba_duv.ba_cd");
                columnPropertyNamesList.add(attr.getName() + ".von.route.ba_cd");
                sb.add(" von.wert as ba_st_von");
                columnNamesList.add("ba_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as ba_st_bis");
                columnNamesList.add("ba_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join duv.fg_ba_duv_linie on (").append(attr.getFieldName()).append(" = duv.fg_ba_duv_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join duv.fg_ba_duv_punkt von on (von.id = duv.fg_ba_duv_linie.von)");
                joins.append(joinExtension).append(" join duv.fg_ba_duv_punkt bis on (bis.id = duv.fg_ba_duv_linie.bis)");
                joins.append(joinExtension).append(" join duv.fg_ba_duv on (von.route = duv.fg_ba_duv.id)");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "duv.fg_ba_duv", ++lineId, "ba_cd");
                this.stationTypes.put("ba_st_von", s);
                s = new StationInfo(true, false, "duv.fg_ba_duv", lineId, "ba_cd");
                this.stationTypes.put("ba_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("sg_umring_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("duv.sg_umring.see_id");
                columnNamesList.add("see_id");
                sqlColumnNamesList.add("duv.sg_umring.see_id");
                columnPropertyNamesList.add(attr.getName() + ".von.route.see_id");
                sb.add(" von.wert as see_st_von");
                columnNamesList.add("see_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as see_st_bis");
                columnNamesList.add("see_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join duv.sg_umring_linie on (").append(attr.getFieldName()).append(" = duv.sg_umring_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join duv.sg_umring_punkt von on (von.id = duv.sg_umring_linie.von)");
                joins.append(joinExtension).append(" join duv.sg_umring_punkt bis on (bis.id = duv.sg_umring_linie.bis)");
                joins.append(joinExtension).append(" join duv.sg_umring on (von.route = duv.sg_umring.id)");
                primitiveColumnTypesList.add("java.lang.Integer");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "duv.sg_umring", ++lineId, "see_id");
                this.stationTypes.put("ba_st_von", s);
                s = new StationInfo(true, false, "duv.sg_umring", lineId, "see_id");
                this.stationTypes.put("ba_st_bis", s);
            } else if (attr.isForeignKey() && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().equals("fg_ba_duv_ges_linie")) {
                this.sqlGeoField = "geo_field";
                if (!this.additionalGeom) {
                    this.geoField = "geom";
                    sb.add(1, "ST_AsEWKb(geom.geo_field) as " + this.geoField);
                    columnNamesList.add(1, "geom");
                    sqlColumnNamesList.add(1, "geom.geo_field");
                    columnPropertyNamesList.add(1, attr.getName() + ".geom.geo_field");
                    primitiveColumnTypesList.add(1, "Geometry");
                }
                sb.add("duv.fg_ba_duv_ges.ba_cd");
                columnNamesList.add("ba_cd");
                sqlColumnNamesList.add("duv.fg_ba_duv_ges.ba_cd");
                columnPropertyNamesList.add(attr.getName() + ".von.route.ba_cd");
                sb.add(" von.wert as ba_st_von");
                columnNamesList.add("ba_st_von");
                sqlColumnNamesList.add("von.wert");
                columnPropertyNamesList.add(attr.getName() + ".von.wert");
                sb.add(" bis.wert as ba_st_bis");
                columnNamesList.add("ba_st_bis");
                sqlColumnNamesList.add("bis.wert");
                columnPropertyNamesList.add(attr.getName() + ".bis.wert");
                joins.append(joinExtension).append(" join duv.fg_ba_duv_ges_linie on (").append(attr.getFieldName()).append(" = duv.fg_ba_duv_ges_linie.id)");
                if (!this.additionalGeom) {
                    joins.append(" join geom on (geom = geom.id)");
                    this.referencedClass.put(this.geoField, geomMc.getID());
                }
                joins.append(joinExtension).append(" join duv.fg_ba_duv_ges_punkt von on (von.id = duv.fg_ba_duv_ges_linie.von)");
                joins.append(joinExtension).append(" join duv.fg_ba_duv_ges_punkt bis on (bis.id = duv.fg_ba_duv_ges_linie.bis)");
                joins.append(joinExtension).append(" join duv.fg_ba_duv_ges on (von.route = duv.fg_ba_duv_ges.id)");
                primitiveColumnTypesList.add("String");
                primitiveColumnTypesList.add("java.lang.Double");
                primitiveColumnTypesList.add("java.lang.Double");
                s = new StationInfo(true, true, "duv.fg_ba_duv_ges", ++lineId, "ba_cd");
                this.stationTypes.put("ba_st_von", s);
                s = new StationInfo(true, false, "duv.fg_ba_duv_ges", lineId, "ba_cd");
                this.stationTypes.put("ba_st_bis", s);
            } else if (attr.isForeignKey()) {
                MetaClass foreignClass;
                if (this.inheritedWwGr && this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().endsWith("k_ww_gr")) {
                    foreignClass = this.getBeanClass(allClasses, attr.getForeignKeyClassId());
                    String namePropertyName = "ww_gr";
                    ObjectAttribute nameAttr = foreignClass.getEmptyInstance().getAttribute("ww_gr");
                    String alias = "dlm25wPk_ww_gr1";
                    sb.add("dlm25wPk_ww_gr1." + nameAttr.getMai().getFieldName());
                    columnNamesList.add(attr.getName());
                    sqlColumnNamesList.add("dlm25wPk_ww_gr1." + nameAttr.getMai().getFieldName());
                    columnPropertyNamesList.add(attr.getName());
                    this.catalogueTypes.put((String)columnNamesList.get(columnNamesList.size() - 1), attr.getForeignKeyClassId());
                    primitiveColumnTypesList.add(nameAttr.getMai().getJavaclassname());
                } else if (!attr.isForeignKey() || !this.getBeanClassName(allClasses, attr.getForeignKeyClassId()).toLowerCase().endsWith("geom")) {
                    foreignClass = this.getBeanClass(allClasses, attr.getForeignKeyClassId());
                    try {
                        String methodName = "handle" + attr.getName().substring(0, 1).toUpperCase() + attr.getName().substring(1);
                        Method m = this.getClass().getMethod(methodName, MemberAttributeInfo.class, MetaClass.class, List.class, List.class, List.class, List.class, List.class, StringBuilder.class);
                        m.invoke((Object)this, attr, foreignClass, sb, columnNamesList, columnPropertyNamesList, sqlColumnNamesList, primitiveColumnTypesList, joins);
                    }
                    catch (NoSuchMethodException ex) {
                        this.handleCatalogue(attr, foreignClass, sb, columnNamesList, columnPropertyNamesList, sqlColumnNamesList, primitiveColumnTypesList, joins);
                    }
                    catch (Exception exception) {}
                } else {
                    String tmp = (String)sb.remove(sb.size() - 1);
                    sb.add(tmp.substring(0, tmp.length() - 1));
                }
            } else {
                String fieldRestriction = this.getFieldRestriction(mc.getTableName() + "." + attr.getFieldName());
                if (fieldRestriction != null) {
                    sb.add("case when " + fieldRestriction + " then " + mc.getTableName() + "." + attr.getFieldName() + " else null end as" + attr.getName());
                } else {
                    sb.add(mc.getTableName() + "." + attr.getFieldName());
                }
                columnNamesList.add(attr.getName());
                sqlColumnNamesList.add(mc.getTableName() + "." + attr.getFieldName());
                columnPropertyNamesList.add(attr.getName());
                this.primitiveTypes.put((String)columnNamesList.get(columnNamesList.size() - 1), Boolean.TRUE);
                primitiveColumnTypesList.add(attr.getJavaclassname());
            }
            ++i;
        }
        if (this.showFgLa) {
            if (fgLaPosition == -1) {
                fgLaPosition = sb.size();
            }
            sb.add(fgLaPosition, " la_lp.la_cd as la_cd ");
            sb.add(fgLaPosition + 1, " la_lp.statval as la_st ");
            columnNamesList.add(fgLaPosition, "la_cd");
            columnNamesList.add(fgLaPosition + 1, "la_st");
            sqlColumnNamesList.add(fgLaPosition, "la_cd");
            sqlColumnNamesList.add(fgLaPosition + 1, "la_st");
            columnPropertyNamesList.add(fgLaPosition, "la_cd");
            columnPropertyNamesList.add(fgLaPosition + 1, "la_st");
            String baCd = "dlm25w.fg_ba.ba_cd";
            String value = "stat.wert";
            joins.append(" left join dlm25w.fg_la_locate_point la_lp on (la_lp.wert = ").append("stat.wert").append(" and la_lp.ba_cd = ").append("dlm25w.fg_ba.ba_cd").append(")");
            primitiveColumnTypesList.add(fgLaPosition, "BigDecimal");
            primitiveColumnTypesList.add(fgLaPosition + 1, "java.lang.Double");
        }
        for (int n = 0; n < sb.size() - 1; ++n) {
            String tmp = (String)sb.remove(n);
            sb.add(n, tmp + ",");
        }
        sb.add(" from " + mc.getTableName());
        sb.add(joins.toString());
        if (this.additionalJoins != null) {
            sb.add(this.additionalJoins);
        }
        this.selectionString = "Select ";
        if (this.useDistinct) {
            this.selectionString = this.selectionString + "distinct ";
        }
        for (String tmp : sb) {
            if (this.selectionString == null) {
                this.selectionString = tmp;
                continue;
            }
            this.selectionString = this.selectionString + tmp;
        }
        this.columnNames = columnNamesList.toArray(new String[columnNamesList.size()]);
        this.sqlColumnNames = sqlColumnNamesList.toArray(new String[sqlColumnNamesList.size()]);
        this.columnPropertyNames = columnPropertyNamesList.toArray(new String[columnPropertyNamesList.size()]);
        this.primitiveColumnTypes = primitiveColumnTypesList.toArray(new String[primitiveColumnTypesList.size()]);
    }

    protected String getFieldRestriction(String column) {
        return null;
    }

    protected boolean hasAttributeReadPermission(String column, User user) {
        return true;
    }

    protected void handleCatalogue(MemberAttributeInfo attr, MetaClass foreignClass, List<String> sb, List<String> columnNamesList, List<String> columnPropertyNamesList, List<String> sqlColumnNamesList, List<String> primitiveColumnTypesList, StringBuilder joins) {
        String namePropertyName = "name";
        if (this.catalogueNameMap != null && this.catalogueNameMap.get(attr.getName()) != null) {
            namePropertyName = this.catalogueNameMap.get(attr.getName());
        }
        ObjectAttribute nameAttr = foreignClass.getEmptyInstance().getAttribute(namePropertyName);
        String fieldRestriction = this.getFieldRestriction(this.mc.getTableName() + "." + attr.getFieldName());
        if (nameAttr != null) {
            String alias = this.addLeftJoin(joins, foreignClass.getTableName(), this.mc.getTableName() + "." + attr.getFieldName(), "id");
            if (fieldRestriction != null) {
                sb.add("case when " + fieldRestriction + " then " + alias + "." + nameAttr.getMai().getFieldName() + " else null end as " + attr.getName());
            } else {
                sb.add(alias + "." + nameAttr.getMai().getFieldName() + " as " + attr.getName());
            }
            columnNamesList.add(attr.getName());
            sqlColumnNamesList.add(alias + "." + nameAttr.getMai().getFieldName());
            columnPropertyNamesList.add(attr.getName());
            this.catalogueTypes.put(columnNamesList.get(columnNamesList.size() - 1), attr.getForeignKeyClassId());
            primitiveColumnTypesList.add(nameAttr.getMai().getJavaclassname());
        } else {
            if (fieldRestriction != null) {
                sb.add("case when " + fieldRestriction + " then " + this.mc.getTableName() + "." + attr.getFieldName() + " else null end as " + attr.getName());
            } else {
                sb.add(this.mc.getTableName() + "." + attr.getFieldName() + " as " + attr.getName());
            }
            columnNamesList.add(attr.getName());
            sqlColumnNamesList.add(this.mc.getTableName() + "." + attr.getFieldName());
            columnPropertyNamesList.add(attr.getName() + ".name");
            this.catalogueTypes.put(columnNamesList.get(columnNamesList.size() - 1), attr.getForeignKeyClassId());
            primitiveColumnTypesList.add("java.lang.String");
        }
    }

    protected String addLeftJoin(StringBuilder joins, String table, String onClauseLeftSide, String onClauseRightSide) {
        String alias = "";
        int counter = 0;
        while (joins.indexOf(alias = table.replace('.', 'P') + ++counter) != -1) {
        }
        joins.append(" left join ").append(table).append(" ").append(alias).append(" on (").append(onClauseLeftSide).append(" = ").append(alias).append(".").append(onClauseRightSide).append(")");
        return alias;
    }

    protected String getBeanClassName(HashMap<String, MetaClass> allClasses, int classId) {
        return allClasses.get(DOMAIN + classId).toString();
    }

    protected MetaClass getBeanClass(HashMap<String, MetaClass> allClasses, int classId) {
        return allClasses.get(DOMAIN + classId);
    }

    protected MetaClass getGeomClass(HashMap<String, MetaClass> allClasses) {
        for (MetaClass cl : allClasses.values()) {
            if (!cl.getName().toLowerCase().equals("geom")) continue;
            return cl;
        }
        return null;
    }

    public String getIdField() {
        return "id";
    }

    public String getSqlGeoField() {
        return this.sqlGeoField;
    }

    public String getGeoField() {
        return this.geoField;
    }

    public String getSelectString() {
        return this.selectionString;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getPrimitiveColumnTypes() {
        return this.primitiveColumnTypes;
    }

    public boolean isPrimitive(String column) {
        Boolean primitive = this.primitiveTypes.get(column);
        return primitive != null ? primitive : false;
    }

    public boolean isCatalogue(String column) {
        Integer catalogue = this.catalogueTypes.get(column);
        return catalogue != null;
    }

    public Integer getCatalogueClass(String column) {
        Integer catalogueClass = this.catalogueTypes.get(column);
        return catalogueClass;
    }

    public boolean isStation(String column) {
        StationInfo stationInfo = this.stationTypes.get(column);
        return stationInfo != null;
    }

    public StationInfo getStationInfo(String column) {
        StationInfo stationInfo = this.stationTypes.get(column);
        return stationInfo;
    }

    public String[] getColumnPropertyNames() {
        return this.columnPropertyNames;
    }

    public int getReferencedCidsClass(String column) {
        return this.referencedClass.get(column);
    }

    public boolean isReferenceToCidsClass(String column) {
        Integer classId = this.referencedClass.get(column);
        return classId != null;
    }

    public String[] getSqlColumnNames() {
        return this.sqlColumnNames;
    }

    public String getRestriction() {
        return null;
    }

    protected boolean isFullGUAccessAllowed() {
        return this.user == null || this.user.getUserGroup().getName().equalsIgnoreCase("administratoren") || this.user.getUserGroup().getName().equalsIgnoreCase("gaeste_read_gu");
    }
}

