/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FgBaDTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger LOG = Logger.getLogger(FgBaDTrigger.class);
    private static final String FG_BA_D_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_ba_d";
    private static final String FG_BA_D_TABLE_NAME = "dlm25w.fg_ba_d";
    private static final ThreadPoolExecutor SINGLE_THREAD_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", FG_BA_D_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isFgBakObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(FG_BA_D_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    private void restat(final CidsBean cidsBean, User user) {
        if (this.isFgBakObject(cidsBean) && SINGLE_THREAD_EXECUTOR.getPoolSize() < 2) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Connection con = null;
                    try {
                        long start = System.currentTimeMillis();
                        con = FgBaDTrigger.this.getDbServer().getConnectionPool().getLongTermConnection();
                        Statement s = con.createStatement();
                        s.execute("select dlm25w.update_haltethema()");
                        LOG.error((Object)("time to update async for fg_ba_d " + String.valueOf(cidsBean.getMetaObject().getID()) + " :" + (System.currentTimeMillis() - start)));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while executing async fg_ba_d trigger." + String.valueOf(cidsBean.getMetaObject().getID())), (Throwable)e);
                    }
                    finally {
                        if (con != null) {
                            FgBaDTrigger.this.getDbServer().getConnectionPool().releaseDbConnection(con);
                        }
                    }
                }
            });
            SINGLE_THREAD_EXECUTOR.execute(t);
        }
    }
}

