/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FgBakWkTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger LOG = Logger.getLogger(FgBakWkTrigger.class);
    private static final String FG_BAK_WK_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_bak_wk";
    private static final String FG_BAK_WK_TABLE_NAME = "dlm25w.fg_bak_wk";
    private static final ThreadPoolExecutor SINGLE_THREAD_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", FG_BAK_WK_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isFgBakWkObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(FG_BAK_WK_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restat(CidsBean cidsBean, User user) {
        block7: {
            if (!this.isFgBakWkObject(cidsBean)) return;
            Connection con = null;
            try {
                long start = System.currentTimeMillis();
                Integer wkNr = (Integer)cidsBean.getProperty("wk_nr.id");
                if (wkNr != null) {
                    con = this.getDbServer().getConnectionPool().getConnection(true);
                    Statement s = con.createStatement();
                    s.execute("select dlm25w.update_fg_lak_wk(" + String.valueOf(wkNr) + ")");
                    s.execute("select dlm25w.update_k_wk_fg_wk_ordnung()");
                    LOG.error((Object)("time to update stations " + (System.currentTimeMillis() - start)));
                }
                if (con == null) break block7;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while executing fgBakWk trigger.", (Throwable)e);
                break block7;
            }
            this.getDbServer().getConnectionPool().releaseDbConnection(con);
            break block7;
            finally {
                if (con != null) {
                    this.getDbServer().getConnectionPool().releaseDbConnection(con);
                }
            }
        }
        if (SINGLE_THREAD_EXECUTOR.getPoolSize() >= 2) return;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Connection con = null;
                try {
                    con = FgBakWkTrigger.this.getDbServer().getConnectionPool().getConnection(true);
                    Statement s = con.createStatement();
                    s.execute("select dlm25w.migrate_fg_bak_wk_to_fg_lak()");
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while executing async fg_lak_wk trigger.", (Throwable)e);
                }
                finally {
                    if (con != null) {
                        FgBakWkTrigger.this.getDbServer().getConnectionPool().releaseDbConnection(con);
                    }
                }
            }
        };
        SINGLE_THREAD_EXECUTOR.execute(r);
    }
}

