/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.helper;

import Sirius.server.sql.DBConnectionPool;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class DuvRefresher {
    private static final Logger LOG = Logger.getLogger(DuvRefresher.class);
    private DBConnectionPool connectionPool = null;
    private final LinkedBlockingQueue<Integer> jobQueue = new LinkedBlockingQueue();

    private DuvRefresher(DBConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.start();
    }

    public void addFgToRefresh(int fgId) {
        if (!this.jobQueue.contains(fgId)) {
            this.jobQueue.add(fgId);
            LOG.info((Object)("id " + fgId + " added to the duv refresh queue"));
        }
    }

    private void start() {
        Thread t = new Thread("recreate duv"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Integer nextId = null;
                    try {
                        nextId = (Integer)DuvRefresher.this.jobQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (nextId == null) continue;
                    Connection con = null;
                    try {
                        long start = System.currentTimeMillis();
                        con = DuvRefresher.this.connectionPool.getLongTermConnection();
                        Statement s = con.createStatement();
                        con.createStatement().execute("select duv.recreate_fg_ba_duvByFg(" + nextId + ")");
                        LOG.error((Object)("time to update duv by FG " + (System.currentTimeMillis() - start)));
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while update duv by fg.", (Throwable)e);
                        continue;
                    }
                    finally {
                        if (con == null) continue;
                        DuvRefresher.this.connectionPool.releaseDbConnection(con);
                        continue;
                    }
                    break;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static DuvRefresher getInstance(DBConnectionPool connectionPool) {
        return LazyInitialiser.getDuvRefresher(connectionPool);
    }

    private static final class LazyInitialiser {
        private static DuvRefresher INSTANCE = null;

        private LazyInitialiser() {
        }

        private static synchronized DuvRefresher getDuvRefresher(DBConnectionPool connectionPool) {
            if (INSTANCE == null) {
                INSTANCE = new DuvRefresher(connectionPool);
            }
            return INSTANCE;
        }
    }
}

