/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.tools.CidsLayerUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CreateViewAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(CreateViewAction.class);
    private static final String CREATE_VIEW = "CREATE VIEW %1s as %2s";
    private static final String ADD_PERMISSION = "GRANT SELECT ON TABLE %1s TO %2s;";
    private static final String DROP_VIEW_IF_EXISTS = "DROP VIEW IF EXISTS %1s";
    public static final String TASK_NAME = "createView";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        Boolean bl;
        Connection con;
        DomainServerImpl domainServer;
        block21: {
            Boolean bl2;
            block20: {
                Boolean bl3;
                block19: {
                    domainServer = null;
                    con = null;
                    try {
                        String restriction;
                        Integer clazzId = null;
                        User user = null;
                        String schemaName = null;
                        String dbUser = null;
                        AdditionalField[] additionalFields = null;
                        for (ServerActionParameter param : params) {
                            if (ParameterType.CLASS.toString().equals(param.getKey())) {
                                clazzId = (Integer)param.getValue();
                            }
                            if (ParameterType.USER.toString().equals(param.getKey())) {
                                user = (User)param.getValue();
                            }
                            if (ParameterType.SCHEMA.toString().equals(param.getKey())) {
                                schemaName = (String)param.getValue();
                            }
                            if (ParameterType.DB_USER.toString().equals(param.getKey())) {
                                dbUser = (String)param.getValue();
                            }
                            if (!ParameterType.ADDITIONAL_FIELDS.toString().equals(param.getKey())) continue;
                            additionalFields = (AdditionalField[])param.getValue();
                        }
                        domainServer = (DomainServerImpl)this.metaService;
                        con = domainServer.getConnectionPool().getLongTermConnection();
                        dbUser = ActionHelper.quoteIdentifier(con, dbUser);
                        schemaName = ActionHelper.quoteIdentifier(con, schemaName);
                        if (ActionHelper.isInvalidUserName(dbUser)) {
                            bl3 = false;
                            if (domainServer == null) return bl3;
                            if (con == null) return bl3;
                            break block19;
                        }
                        if (ActionHelper.isInvalidSchemaName(schemaName)) {
                            bl2 = false;
                            if (domainServer == null) return bl2;
                            break block20;
                        }
                        MetaClass metaClass = this.metaService.getClass(user, clazzId.intValue());
                        CidsLayerInfo layerInfo = CidsLayerUtil.getCidsLayerInfo((MetaClass)metaClass, (User)user);
                        String whereExtension = "";
                        if (metaClass.getTableName().equalsIgnoreCase("dlm25w.sg_detail") && user.getUserGroup().getName().toLowerCase().startsWith("wbv")) {
                            whereExtension = layerInfo.getSelectString().toLowerCase().contains("where") ? " AND (dlm25wPk_ww_gr1.ww_gr >= 4000 OR dlm25wPk_ww_gr1.ww_gr < 3000 OR dlm25wPk_ww_gr1.owner = '" + user.getUserGroup().getName() + "')" : " WHERE (dlm25wPk_ww_gr1.ww_gr >= 4000 OR dlm25wPk_ww_gr1.ww_gr < 3000 OR dlm25wPk_ww_gr1.owner = '" + user.getUserGroup().getName() + "')";
                        }
                        if ((restriction = layerInfo.getRestriction()) != null) {
                            whereExtension = layerInfo.getSelectString().toLowerCase().contains("where") || !whereExtension.equals("") ? whereExtension + " AND (" + restriction + ")" : " WHERE (" + restriction + ")";
                        }
                        Statement st = con.createStatement();
                        String selectStatement = layerInfo.getSelectString().replace("ST_AsEWKb(geom.geo_field)", "st_setSrid(geom.geo_field, 5650)");
                        selectStatement = selectStatement.replace("ST_AsEWKb(geom)", "st_setSrid(geom, 5650)");
                        selectStatement = selectStatement.replace("ST_AsEWKb", "");
                        if (additionalFields != null && selectStatement.toLowerCase().contains(" from ")) {
                            String start = selectStatement.substring(0, selectStatement.toLowerCase().indexOf(" from "));
                            String end = selectStatement.substring(selectStatement.toLowerCase().indexOf(" from "));
                            selectStatement = start;
                            for (AdditionalField field : additionalFields) {
                                selectStatement = selectStatement + ", " + field.getValue() + " as " + field.getName();
                            }
                            selectStatement = selectStatement + end;
                        }
                        st.executeUpdate(String.format(DROP_VIEW_IF_EXISTS, schemaName + "." + metaClass.getName()));
                        st.executeUpdate(String.format(CREATE_VIEW, schemaName + "." + metaClass.getName(), selectStatement + whereExtension));
                        st.executeUpdate(String.format(ADD_PERMISSION, schemaName + "." + metaClass.getName(), dbUser));
                        bl = true;
                        if (domainServer == null) return bl;
                        break block21;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while extracting the data sources", (Throwable)e);
                        Boolean bl4 = false;
                        return bl4;
                    }
                }
                domainServer.getConnectionPool().releaseDbConnection(con);
                return bl3;
            }
            if (con == null) return bl2;
            domainServer.getConnectionPool().releaseDbConnection(con);
            return bl2;
        }
        if (con == null) return bl;
        domainServer.getConnectionPool().releaseDbConnection(con);
        return bl;
        finally {
            if (domainServer != null && con != null) {
                domainServer.getConnectionPool().releaseDbConnection(con);
            }
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static class AdditionalField
    implements Serializable {
        private String name;
        private Integer pos;
        private String value;

        public AdditionalField(String name, Integer pos, String value) {
            this.name = name;
            this.pos = pos;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPos() {
            return this.pos;
        }

        public void setPos(Integer pos) {
            this.pos = pos;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum ParameterType {
        CLASS,
        USER,
        SCHEMA,
        DB_USER,
        ADDITIONAL_FIELDS;

    }
}

