/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class SchemaExistsAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(SchemaExistsAction.class);
    private static final String SCHEMA_EXISTS = "SELECT schema_name FROM information_schema.schemata WHERE schema_name = ?;";
    public static final String TASK_NAME = "schemaExists";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        Boolean bl;
        Connection con;
        DomainServerImpl domainServer;
        block13: {
            Boolean bl2;
            block12: {
                boolean schemaExists = false;
                domainServer = null;
                con = null;
                try {
                    String schemaName = null;
                    for (ServerActionParameter param : params) {
                        if (!ParameterType.SCHEMA.toString().equals(param.getKey())) continue;
                        schemaName = (String)param.getValue();
                    }
                    if (ActionHelper.isInvalidSchemaName(schemaName)) {
                        bl2 = false;
                        if (domainServer == null) return bl2;
                        if (con == null) return bl2;
                        break block12;
                    }
                    domainServer = (DomainServerImpl)this.metaService;
                    con = domainServer.getConnectionPool().getLongTermConnection();
                    PreparedStatement preparedStatement = con.prepareStatement(SCHEMA_EXISTS);
                    preparedStatement.setString(1, schemaName);
                    boolean res = preparedStatement.execute();
                    if (res) {
                        ResultSet rs = preparedStatement.getResultSet();
                        if (rs != null && rs.next()) {
                            schemaExists = true;
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    preparedStatement.close();
                    bl = schemaExists;
                    if (domainServer == null) return bl;
                    break block13;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while checking, if the given schema already exists", (Throwable)e);
                    Boolean bl3 = schemaExists;
                    return bl3;
                }
            }
            domainServer.getConnectionPool().releaseDbConnection(con);
            return bl2;
        }
        if (con == null) return bl;
        domainServer.getConnectionPool().releaseDbConnection(con);
        return bl;
        finally {
            if (domainServer != null && con != null) {
                domainServer.getConnectionPool().releaseDbConnection(con);
            }
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        SCHEMA;

    }
}

