/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AllGewBySb
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllGewBySb.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select id, art, ba_cd, ba_st_von, ba_st_bis, sb, sb_name, owner, gew_name, gu, wdm, ba_len, gu_name from dlm25w.select_sb(%1$s, %2$s)";
    private final int[] routeIds;
    private final int[] wdmArray;

    public AllGewBySb(int[] routeIds, int[] wdmArray) {
        this.routeIds = routeIds;
        this.wdmArray = wdmArray;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, SQLFormatter.createSqlArrayString(this.routeIds), SQLFormatter.createSqlArrayString(this.wdmArray)));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

