/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AllGewGeschlByGem
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllGewGeschlByGem.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select id, owner, gu, wdm, gew_name, tf, dim, art, ba_cd, ba_st_von, ba_st_bis, nr_re, nr_li, ls, prof, ma, objNr, tr, ausbaujahr, wbbl, code, zustKl, br, brOben, hoehe, hEin, hAus, gefaelle, dhAus, dhEin, hAb, hAuf, aufstieg, trGu, objNrGu from dlm25w.select_gmd_geschl(%1$s, %2$s, %3$s)";
    private static final String QUERY_WITHOUT_GEM = "select id, owner, gu, wdm, gew_name, tf, dim, art, ba_cd, ba_st_von, ba_st_bis, nr_re, nr_li, ls, prof, ma, objNr, tr, ausbaujahr, wbbl, code, zustKl, br, brOben, hoehe, hEin, hAus, gefaelle, dhAus, dhEin, hAb, hAuf, aufstieg, trGu, objNrGu from dlm25w.select_gmd_geschl(%1$s, %2$s)";
    private final int gemId;
    private final int[] routeIds;
    private final int[] wdmArray;
    private boolean withoutGem = false;

    public AllGewGeschlByGem(int[] routeIds, int[] wdmArray) {
        this.gemId = 0;
        this.routeIds = routeIds;
        this.wdmArray = wdmArray;
        this.withoutGem = true;
    }

    public AllGewGeschlByGem(int gemId, int[] routeIds, int[] wdmArray) {
        this.gemId = gemId;
        this.routeIds = routeIds;
        this.wdmArray = wdmArray;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                if (this.withoutGem) {
                    String query = String.format(QUERY_WITHOUT_GEM, SQLFormatter.createSqlArrayString(this.routeIds), SQLFormatter.createSqlArrayString(this.wdmArray));
                    ArrayList lists = ms.performCustomSearch(query);
                    return lists;
                }
                String query = String.format(QUERY, this.gemId, SQLFormatter.createSqlArrayString(this.routeIds), SQLFormatter.createSqlArrayString(this.wdmArray));
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

