/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AllGewOffenByGem
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllGewOffenByGem.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select id,owner,gu,wdm,gew_name,ba_cd,ba_st_von,ba_st_bis,nr_re,nr_li,profil,wk_fg_length, bv_re,bl_n_li,fl_b_re,bl_n_re,fl_b,fl_bt_re,fl_n,fl_ger,br_gew_re,fl_bn_re,bh_re,wbbl,fl_qs_ger,fl_bn,typ,bl_li,fl_bn_li,bh_li,bl_t_li,bemerkung,br_gew,ausbaujahr,fl_so,br_gew_li,ho_a,fl_gew,fl_qs_gew,br_so,ho_e,fl_bt,mw,fl_bt_li,gefaelle,bl_t_re,bv_li,fl_b_li,bl_re,obj_nr from dlm25w.select_gmd_gero(%1$s, %2$s, %3$s)";
    private static final String QUERY_WITHOUT_GEM = "select id,owner,gu,wdm,gew_name,ba_cd,ba_st_von,ba_st_bis,nr_re,nr_li,profil,wk_fg_length, bv_re,bl_n_li,fl_b_re,bl_n_re,fl_b,fl_bt_re,fl_n,fl_ger,br_gew_re,fl_bn_re,bh_re,wbbl,fl_qs_ger,fl_bn,typ,bl_li,fl_bn_li,bh_li,bl_t_li,bemerkung,br_gew,ausbaujahr,fl_so,br_gew_li,ho_a,fl_gew,fl_qs_gew,br_so,ho_e,fl_bt,mw,fl_bt_li,gefaelle,bl_t_re,bv_li,fl_b_li,bl_re,obj_nr from dlm25w.select_gmd_gero(%1$s, %2$s)";
    private final int gemId;
    private final int[] routeIds;
    private final int[] wdmArray;
    private boolean withoutGem = false;

    public AllGewOffenByGem(int[] routeIds, int[] wdmArray) {
        this.gemId = 0;
        this.routeIds = routeIds;
        this.wdmArray = wdmArray;
        this.withoutGem = true;
    }

    public AllGewOffenByGem(int gemId, int[] routeIds, int[] wdmArray) {
        this.gemId = gemId;
        this.routeIds = routeIds;
        this.wdmArray = wdmArray;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                if (this.withoutGem) {
                    String query = String.format(QUERY_WITHOUT_GEM, SQLFormatter.createSqlArrayString(this.routeIds), SQLFormatter.createSqlArrayString(this.wdmArray));
                    ArrayList lists = ms.performCustomSearch(query);
                    return lists;
                }
                String query = String.format(QUERY, this.gemId, SQLFormatter.createSqlArrayString(this.routeIds), SQLFormatter.createSqlArrayString(this.wdmArray));
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

