/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.tools.CidsLayerUtil;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AllLineObjects
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllLineObjects.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select ba.id, st_length(geo_field), ba.ba_cd, von.wert, bis.wert, von.route, %3$s\nfrom dlm25w.%1$s m \njoin dlm25w.fg_ba_linie l on (m.ba_st = l.id)\njoin dlm25w.fg_ba_punkt von on (l.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (l.bis = bis.id)\njoin dlm25w.fg_ba ba on (von.route = ba.id)\njoin geom g on (g.id = l.geom)\nwhere (%2$s is null or von.route = any(%2$s))\norder by ba_cd, least(von.wert, bis.wert)";
    private static final String QUERY_WITH_RESTRICTION = "select ba.id, st_length(geo_field), ba.ba_cd, von.wert, bis.wert, von.route, %4$s\nfrom dlm25w.%1$s m \njoin dlm25w.fg_ba_linie l on (m.ba_st = l.id)\njoin dlm25w.fg_ba_punkt von on (l.von = von.id)\njoin dlm25w.fg_ba_punkt bis on (l.bis = bis.id)\njoin dlm25w.fg_ba ba on (von.route = ba.id)\njoin geom g on (g.id = l.geom)\n left join dlm25w.k_ww_gr dlm25wPk_ww_gr1 on (ba.ww_gr = dlm25wPk_ww_gr1.id)\nwhere (%2$s is null or von.route = any(%2$s)) and (%3$s) \norder by ba_cd, least(von.wert, bis.wert)";
    protected final Table table;
    protected final int[] gew;

    public AllLineObjects(Table table, int[] gew) {
        this.table = table;
        this.gew = gew;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                MetaClass metaClass = ms.getClassByTableName(this.getUser(), "dlm25w." + this.table.toString(), ConnectionContext.createDummy());
                CidsLayerInfo info = CidsLayerUtil.getCidsLayerInfo((MetaClass)metaClass, (User)this.getUser());
                String idField = "m.id";
                if (this.table.toString().equals("fg_ba_sb")) {
                    idField = "sb";
                } else if (this.table.toString().equals("fg_ba_gmd")) {
                    idField = "nr_li";
                } else if (this.table.toString().equals("fg_ba_gb")) {
                    idField = "nr_li";
                }
                if (info != null && info.getRestriction() != null) {
                    ArrayList lists = ms.performCustomSearch(String.format(QUERY_WITH_RESTRICTION, this.table.toString(), SQLFormatter.createSqlArrayString(this.gew), info.getRestriction(), idField));
                    return lists;
                }
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.table.toString(), SQLFormatter.createSqlArrayString(this.gew), idField));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public static enum Table {
        fg_ba_gb,
        fg_ba_gmd,
        fg_ba_prof,
        fg_ba_sbef,
        fg_ba_ubef,
        fg_ba_bbef,
        fg_ba_sb,
        fg_ba_rl,
        fg_ba_d,
        fg_ba_due,
        fg_ba_anll,
        deich_ft,
        fg_ba_ughz,
        fg_ba_leis,
        fg_ba_tech,
        fg_ba_doku,
        fg_ba_proj;

    }
}

