/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.tools.CidsLayerUtil;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AllPunktObjects
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllPunktObjects.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select von.route, ba.ba_cd, von.wert, m.id\nfrom dlm25w.%1$s m \njoin dlm25w.fg_ba_punkt von on (m.ba_st = von.id)\njoin dlm25w.fg_ba ba on (von.route = ba.id)\nwhere (%2$s is null or von.route = any(%2$s))\norder by ba.ba_cd, von.wert";
    private static final String QUERY_WITH_RESTRICTION = "select von.route, ba.ba_cd, von.wert, m.id\nfrom dlm25w.%1$s m \njoin dlm25w.fg_ba_punkt von on (m.ba_st = von.id)\njoin dlm25w.fg_ba ba on (von.route = ba.id)\n left join dlm25w.k_ww_gr dlm25wPk_ww_gr1 on (ba.ww_gr = dlm25wPk_ww_gr1.id)\nwhere (%2$s is null or von.route = any(%2$s)) and (%3$s)\norder by ba.ba_cd, von.wert";
    private static final String QUERY_WITH_RESTRICTION_FOTO = "select von.route, ba.ba_cd, von.wert, m.id\nfrom dlm25w.%1$s m \njoin dlm25w.fg_ba_punkt von on (m.ba_st = von.id)\njoin dlm25w.fg_ba ba on (von.route = ba.id)\njoin dlm25w.k_freigabe dlm25wPk_freigabe1 on (m.freigabe = dlm25wPk_freigabe1.id)\n left join dlm25w.k_ww_gr dlm25wPk_ww_gr1 on (ba.ww_gr = dlm25wPk_ww_gr1.id)\nwhere (%2$s is null or von.route = any(%2$s)) and (%3$s)\norder by ba.ba_cd, von.wert";
    private final Table table;
    private final int[] gew;

    public AllPunktObjects(Table table, int[] gew) {
        this.table = table;
        this.gew = gew;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                MetaClass metaClass = ms.getClassByTableName(this.getUser(), "dlm25w." + this.table.toString(), ConnectionContext.createDummy());
                CidsLayerInfo info = CidsLayerUtil.getCidsLayerInfo((MetaClass)metaClass, (User)this.getUser());
                if (info != null && info.getRestriction() != null) {
                    if (this.table.equals((Object)Table.foto)) {
                        ArrayList lists = ms.performCustomSearch(String.format(QUERY_WITH_RESTRICTION_FOTO, this.table.toString(), SQLFormatter.createSqlArrayString(this.gew), info.getRestriction()));
                        return lists;
                    }
                    ArrayList lists = ms.performCustomSearch(String.format(QUERY_WITH_RESTRICTION, this.table.toString(), SQLFormatter.createSqlArrayString(this.gew), info.getRestriction()));
                    return lists;
                }
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.table.toString(), SQLFormatter.createSqlArrayString(this.gew)));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public static enum Table {
        wr_wbu_ben,
        wr_wbu_aus,
        mn_ow_pegel,
        fg_ba_scha,
        fg_ba_wehr,
        fg_ba_schw,
        fg_ba_anlp,
        fg_ba_kr,
        fg_ba_ea,
        foto;

    }
}

