/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class CalculateFgLa
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(CalculateFgLa.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select la_cd, la_st from dlm25w.calc_la_value(?, ?)";
    private final String baCd;
    private final double baSt;

    public CalculateFgLa(String baCd, double baSt) {
        this.baCd = baCd;
        this.baSt = baSt;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                PreparableStatement ps = new PreparableStatement(QUERY, new int[]{12, 8});
                ps.setObjects(new Object[]{this.baCd, this.baSt});
                ArrayList lists = ms.performCustomSearch(ps);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

