/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class GafCatalogueValues
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(GafCatalogueValues.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_KZ = "select kz, hyk from dlm25w.k_qp_gaf_kz";
    private static final String QUERY_BK = "select bk from dlm25w.k_qp_gaf_bk";
    private static final String QUERY_RK = "select rk from dlm25w.k_qp_gaf_rk";

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList<ArrayList> results = new ArrayList<ArrayList>();
                ArrayList listKz = ms.performCustomSearch(QUERY_KZ);
                ArrayList listRk = ms.performCustomSearch(QUERY_RK);
                ArrayList listBk = ms.performCustomSearch(QUERY_BK);
                results.add(listKz);
                results.add(listRk);
                results.add(listBk);
                return results;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

