/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class LawaCount
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(LawaCount.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String DIRECTION_QUERY_WITHOUT_OWNER = "select count(distinct la_cd) from dlm25w.fg_lak";
    private static final String DIRECTION_QUERY = "select count(distinct lak.la_cd) from dlm25w.fg_lak lak  join dlm25w.fg_bak_gwk gwk on (gwk.la_cd = lak.la_cd)\n join dlm25w.fg_bak_linie bak_linie on (gwk.bak_st = bak_linie.id) \n join dlm25w.fg_bak_punkt bak_von on (bak_linie.von = bak_von.id)\n join dlm25w.fg_bak bak on (bak_von.route = bak.id)\n left join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr) where gr.owner = '%1$s'";
    private final String owner;

    public LawaCount(String owner) {
        this.owner = owner;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = this.owner == null ? DIRECTION_QUERY_WITHOUT_OWNER : String.format(DIRECTION_QUERY, this.owner);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

