/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.custom.watergis.server.search.MergeFgBakGwk;
import de.cismet.cids.custom.watergis.server.search.WritableSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MoveFgBakAfterSplit
extends WritableSearch {
    private static final transient Logger LOG = Logger.getLogger(MergeFgBakGwk.class);
    private static final String QUERY = "select dlm25w.move_fg_bak_to_new_route_after_split(?, ?);";
    public static final String DOMAIN_NAME = "DLM25W";
    private final int fgBakId;
    private final int newFgBaId;

    public MoveFgBakAfterSplit(int fgBakId, int newFgBaId) {
        this.fgBakId = fgBakId;
        this.newFgBaId = newFgBaId;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                PreparableStatement ps = new PreparableStatement(QUERY, new int[]{4, 4});
                ps.setObjects(new Object[]{this.fgBakId, this.newFgBaId});
                ArrayList lists = ms.performCustomSearch(ps);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

