/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PhotoGetLaStat
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(PhotoGetLaStat.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select null, la_cd, round((ST_LineLocatePoint(geo_field, '%1$s') * st_length(geo_field))::numeric, 2)::double precision as stat,null as point from\n(select ba.id, k.la_cd, geo_field from dlm25w.fg_la ba join geom on (geom = geom.id) join dlm25w.k_gwk_lawa k on  (k.id = ba.la_cd) \nwhere st_distance(geo_field, '%1$s') <= 0.1\norder by st_distance(geo_field, '%1$s') asc\nlimit 1) ba";
    private final Geometry geom;

    public PhotoGetLaStat(Geometry geom) {
        this.geom = geom;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.geom.toText()));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

