/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class QpUplNameByNr
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(QpUplNameByNr.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "Select upl_name from dlm25w.qp where qp_nr = %s";
    private final String qpNr;

    public QpUplNameByNr(String qpNr) {
        this.qpNr = qpNr;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.qpNr));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

