/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.watergis.server.search.MergeFgBakGwk;
import de.cismet.cids.custom.watergis.server.search.WritableSearch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RecoverFgBakAfterSplit
extends WritableSearch {
    private static final transient Logger LOG = Logger.getLogger(MergeFgBakGwk.class);
    private static final String QUERY = "select dlm25w.recover_fg_bak_after_split(?,?);";
    public static final String DOMAIN_NAME = "DLM25W";
    private final int fgBakId;
    private final int[] statIds;

    public RecoverFgBakAfterSplit(int fgBakId, int[] statIds) {
        this.fgBakId = fgBakId;
        this.statIds = statIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performServerSearch() {
        block9: {
            MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
            if (ms != null) {
                ArrayList<ArrayList> arrayList;
                block8: {
                    Connection connection = null;
                    try {
                        ArrayList<ArrayList> lists;
                        Object[] intArray = new Object[this.statIds.length];
                        for (int i = 0; i < this.statIds.length; ++i) {
                            intArray[i] = this.statIds[i];
                        }
                        connection = DomainServerImpl.getServerInstance().getConnectionPool().getLongTermConnection();
                        PreparedStatement merge = connection.prepareStatement(QUERY);
                        merge.setArray(1, connection.createArrayOf("integer", intArray));
                        merge.setInt(2, this.fgBakId);
                        ResultSet rs = merge.executeQuery();
                        arrayList = lists = this.collectResults(rs);
                        if (connection == null) break block8;
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)ex.getMessage(), (Throwable)ex);
                        break block9;
                    }
                    finally {
                        if (connection != null) {
                            DomainServerImpl.getServerInstance().getConnectionPool().releaseDbConnection(connection);
                        }
                    }
                    DomainServerImpl.getServerInstance().getConnectionPool().releaseDbConnection(connection);
                }
                return arrayList;
            }
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

