/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RemoveOldLocks
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(RemoveOldLocks.class);
    private static final String QUERY = "select dlm25w.deleteLocksFromUser(?, ?)";
    public static final String DOMAIN_NAME = "DLM25W";
    private String owner;
    private String computerName;

    public RemoveOldLocks(String owner, String computerName) {
        this.owner = owner;
        this.computerName = computerName;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                PreparableStatement ps = new PreparableStatement(QUERY, new int[]{12, 12});
                ps.setObjects(new Object[]{this.owner, this.computerName});
                ms.performCustomSearch(ps);
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

