/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RouteEnvelopes
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(RouteEnvelopes.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "Select \nst_asBinary(st_envelope(geom.geo_field)) as geom,\ndlm25w.fg_ba.ba_cd, dlm25w.fg_ba.id \nfrom dlm25w.fg_ba \njoin geom on (geom = geom.id) \nleft join dlm25w.k_ww_gr dlm25wPk_ww_gr1 on (dlm25w.fg_ba.ww_gr = dlm25wPk_ww_gr1.id) \n%1$sORDER BY ba_cd COLLATE \"POSIX\" asc";
    private static final String QUERY_MIN = "Select \ndlm25w.fg_ba.id \nfrom dlm25w.fg_ba \njoin geom on (geom = geom.id) \nleft join dlm25w.k_ww_gr dlm25wPk_ww_gr1 on (dlm25w.fg_ba.ww_gr = dlm25wPk_ww_gr1.id) \n%1$s";
    private final String whereCondition;
    private boolean min = false;

    public RouteEnvelopes(String whereCondition) {
        this(whereCondition, false);
    }

    public RouteEnvelopes(String whereCondition, boolean min) {
        this.min = min;
        this.whereCondition = whereCondition == null ? " " : "where " + whereCondition;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = this.min ? String.format(QUERY_MIN, this.whereCondition) : String.format(QUERY, this.whereCondition);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

