/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class UniquenessCheck
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(UniquenessCheck.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_CONDITION = "(id <> %s and %s = '%s')";
    private static final String QUERY = "select %s from dlm25w.%s ";
    private final Map<Integer, String> valueMap;
    private final String field;
    private final String table;

    public UniquenessCheck(Map<Integer, String> valueMap, String field, String table) {
        this.valueMap = valueMap;
        this.field = field;
        this.table = table;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                boolean first = true;
                String query = String.format(QUERY, this.field, this.table);
                for (Integer id : this.valueMap.keySet()) {
                    String value = this.valueMap.get(id);
                    if (first) {
                        query = query + " WHERE ";
                        first = false;
                    } else {
                        query = query + " OR ";
                    }
                    query = query + String.format(QUERY_CONDITION, id, this.field, value);
                }
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

