/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class WsgRechtSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(WsgRechtSearch.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_STAT = "select wsg_anz, wsg_fl, anz_brd, anz_ddr from dlm25w.wr_sg_wsg_stat;";
    private static final String QUERY_RECHT = "select recht, st_area(geom) from dlm25w.wr_sg_wsg_rgl;";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList tmp;
                ArrayList result = new ArrayList();
                ArrayList lists = ms.performCustomSearch(QUERY_STAT);
                if (lists != null && lists.size() > 0 && (tmp = (ArrayList)lists.get(0)) != null && tmp.size() > 1) {
                    result.add(tmp.get(0));
                    result.add(tmp.get(1));
                    result.add(tmp.get(2));
                    result.add(tmp.get(3));
                }
                lists = ms.performCustomSearch(QUERY_RECHT);
                Object brd = null;
                Object ddr = null;
                if (lists != null && lists.size() > 0) {
                    for (ArrayList tmp2 : lists) {
                        if (tmp2 == null || tmp2.size() <= 1) continue;
                        if (tmp2.get(0) != null && tmp2.get(0).equals("BRD")) {
                            brd = tmp2.get(1);
                            continue;
                        }
                        if (tmp2.get(0) == null || !tmp2.get(0).equals("DDR")) continue;
                        ddr = tmp2.get(1);
                    }
                }
                result.add(brd);
                result.add(ddr);
                return result;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.connectionContext = this.connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

