/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SgSuTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger log = Logger.getLogger(SgSuTrigger.class);
    private static final String SG_SU_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.sg_su";
    private static final String SG_SU_TABLE_NAME = "dlm25w.sg_su";

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", SG_SU_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isFgBakObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(SG_SU_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restat(CidsBean cidsBean, User user) {
        if (!this.isFgBakObject(cidsBean)) return;
        Connection con = null;
        try {
            long start = System.currentTimeMillis();
            Integer id = cidsBean.getMetaObject().getID();
            con = this.getDbServer().getConnectionPool().getLongTermConnection();
            Statement s = con.createStatement();
            s.execute("select dlm25w.replace_sg_su(" + ((Object)id).toString() + ")");
            s.execute("select dlm25w.add_sg_su_stat(" + ((Object)id).toString() + ")");
            log.error((Object)("time to update stations " + (System.currentTimeMillis() - start)));
            if (con == null) return;
        }
        catch (Exception e) {
            try {
                log.error((Object)"Error while executing fgBak trigger.", (Throwable)e);
                if (con == null) return;
            }
            catch (Throwable throwable) {
                if (con == null) throw throwable;
                this.getDbServer().getConnectionPool().releaseDbConnection(con);
                throw throwable;
            }
            this.getDbServer().getConnectionPool().releaseDbConnection(con);
            return;
        }
        this.getDbServer().getConnectionPool().releaseDbConnection(con);
        return;
    }
}

